;SLIDE Math Library 

 INCLUDE "libraries.inc"

 CreateLibrary Math,Plus,Minus,Mult,Inc,Dec,Rand,BoolAnd,BoolOr,BoolXor,Div





 IFDEF __BoolAnd
_BoolAnd_:
       call   LdDEHLIndConvVal
       push   hl 
       call   LdHLIndConvVal
       ld     a,h
       and    d
       ld     h,a
       ld     a,l
       and    e
       ld     l,a
       jr     MathCont
 ENDIF     
 
 IFDEF __BoolOr
_BoolOr_:
       call   LdDEHLIndConvVal
       push   hl
       call   LdHLIndConvVal
       ld     a,h
       or     d
       ld     h,a
       ld     a,l
       or     e
       ld     l,a
       jr     MathCont
 ENDIF

 IFDEF __BoolXor
_BoolXor_:
       call   LdDEHLIndConvVal
       push   hl
       call   LdHLIndConvVal
       ld     a,h
       xor    d
       ld     h,a
       ld     a,l
       xor    e
       ld     l,a
       jr     MathCont
 ENDIF

 IFDEF __Rand
 IFNDEF __MultBCDE
 DEFINE __MultBCDE
 ENDIF
 RAMVar RandomSeeded,byte
 RAMVar CurRand,word
_Rand_:
       ld     a,(RandomSeeded)
       or     a
       jr     nz,RandomAlreadySeeded
       push   hl
       inc    a
       ld     (RandomSeeded),a
       B_CALL Random
       ld     hl,seed1
       rst    20h
       ld     a,83h
       ld     (OP1+1),a
       B_CALL ConvOP1
;       ld     b,a
;       ld     a,r
;       and    110b
;       xor    b
       push   af
       ld     hl,seed2
       rst    20h
       ld     a,83h
       ld     (OP1+1),a
       B_CALL ConvOP1
       pop    hl
;       ld     l,a
;       ld     a,r
;       and    11000b
 ;      xor    l
       ld     l,a
       ld     (CurRand),hl
       pop    hl
RandomAlreadySeeded:
       ld     e,(hl)
       inc    hl
       ld     d,(hl)
       inc    hl
       push   hl
       call   ConvVal16BitDE
       push   de
       call   DoRandom      ;Get random 16 bit number in HL



       ex     de,hl
       pop    bc
       call   MultBCDE
       pop    hl
       B_CALL LdHLInd
       ex     de,hl
       ld     h,b
       ld     l,c
       jp     LoadToVar
DoRandom:




	ld	hl,(CurRand)
	ld	b,h
	ld	c,l
	add	hl,hl ;2
	add	hl,hl ;4
       add    hl,hl ;8
       add    hl,hl ;16
       add    hl,hl ;32
       add    hl,hl ;64
       add    hl,hl ;128
       add    hl,hl ;256
       add    hl,bc ;257
	ld	bc,13901
	add	hl,bc

	ld	(CurRand),hl
       ret
 ENDIF

 IFDEF __Inc
_Inc_:
       B_CALL LdHLInd
       push   hl
       call   ConvVal16Bit
       inc    hl
       pop    de
       jp     LoadToVar
 ENDIF

 IFDEF __Dec
_Dec_:
       B_CALL LdHLInd
       push   hl
       call   ConvVal16Bit
       dec    hl
       pop    de
       jp     LoadToVar
 ENDIF


 IFDEF __Div
_Div_:
       call   LdDEHLIndConvVal
       push   hl
       call   LdHLIndConvVal
       ld     a,l
       ex     de,hl
       B_CALL DivHLByA
       jr     MathCont
 ENDIF


 IFDEF __Mult
 IFNDEF __MultBCDE
 DEFINE __MultBCDE
 ENDIF
_Mult_:
       call   LdDEHLIndConvVal
       push   hl
       call   LdHLIndConvVal
       ld     b,h
       ld     c,l
       call   MultBCDE
       jr     MathCont

 ENDIF

 IFDEF __MultBCDE
MultBCDE:
       ld     hl,0
       ld     a,16
MultLoop:
       add    hl,hl
       rl     c
       rl     b
       jr     nc,MultSkipStuff
       add    hl,de
       jr     nc,MultSkipStuff
       inc    bc                         
MultSkipStuff:
       dec    a
       jr     nz,MultLoop
       ret
 ENDIF
      
 IFDEF __Minus
_Minus_:
       call   LdDEHLIndConvVal
       push   hl
       call   LdHLIndConvVal
       ex     de,hl
       or     a
       sbc    hl,de
       jr     MathCont
 ENDIF
 


 IFDEF __Plus
_Plus_:
       call   LdDEHLIndConvVal
       push   hl
       call   LdHLIndConvVal
       add    hl,de
       jr     MathCont
 ENDIF

MathCont:
       pop    de
       push   hl
       ex     de,hl
       inc    hl
       inc    hl
       ld     e,(hl)
       inc    hl
       ld     d,(hl)
       pop    hl
       jp     LoadToVar

MathNext:
 IFDEF _S_Plus
       db     8
 ENDIF
 IFDEF _S_Minus
       db     8
 ENDIF
 IFDEF _S_Mult
       db     8
 ENDIF
 IFDEF _S_Inc
       db     4
 ENDIF
 IFDEF _S_Dec
       db     4
 ENDIF
 IFDEF _S_Rand
       db     6
 ENDIF
 IFDEF _S_BoolAnd
       db     8
 ENDIF
 IFDEF _S_BoolOr
       db     8
 ENDIF
 IFDEF _S_BoolXor
       db     8
 ENDIF
 IFDEF _S_Div
       db     8
 ENDIF



