;SLIDE

;Tips and Tricks:
;-Use loop commands when possible, they're smaller and faster
;-If you're short on space, you can take out the commands you're not using
;-Interpreted, so overhead with each command; try to reduce # of commands
;-Regular variables are faster, use them unless you have a reason to use floats

;Limitations:
;-Variables limited to 32767
;-FLoad limited to 16383
;-FConv limited to 9999
;-Floating point limited to +-9E99
;-Rand output will tend (about 5%) randomly toward either even or odd numbers (use FRand for more
; uniform output)
;-Applications must be single page

;Interpreter - 366,335,347
;GFXLib - 364
;TextLib - 179,146
;Main - 274
;Misc - 130,128
;Math - 262
;Silver - 84
;Float - 502,479
;AppVar - 121

 TITLE "SLIDE Main Program File"
 INCLUDE "settings.inc"
 IFDEF TI83P
 INCLUDE "ti83plus.inc"
 ENDIF
 IFDEF TI73
 INCLUDE "ti73asm.inc"
 ENDIF 
 DEFINE Main, Space=ROM
 DEFINE InternalRAM, Space=ROM
 DEFINE CommandData, Space=ROM
 DEFINE LibraryTable, Space=ROM


 INCLUDE "equates.inc"
 SEGMENT Main
 INCLUDE "header.asm"

       IFDEF TI83P
       B_CALL ForceFullScreen
       B_CALL SetTblGraphDraw
       ENDIF
       IFDEF TI73
       AppOffErr
       B_CALL DisableAPI
       ld     hl,DummyReturn
       ld     (appRawKeyHandle),hl
       in     a,(6)
       ld     (appPage),a
       ENDIF
       B_CALL ClrLCDFull
       B_CALL GrBufClr
       B_CALL DelRes
       ld     hl,appBackUpScreen
       ld     bc,768
       B_CALL MemClear
       ld     hl,(saveSScreen+768)
       ld     (SaveSScreenSave),hl
       ld     hl,_MainSlide
;       jp     SlideInterpreter

SlideInterpreter:
       res    SkipNextCmd,(iy+SlideFlags)
       ld     (SlidePtr),hl
       xor    a
       ld     (SlideDepth),a
       ld     hl,Variables
       ld     bc,NumVariables*2
       B_CALL MemClear
SlideLoop:
       ld     hl,(SlidePtr)
       ld     a,(hl)
       ex     de,hl
       ld     hl,LibTable-5
       ld     bc,5
LookupLibraryTableLoop:
       add    hl,bc
       cp     (hl)
       jp     nz,LookupLibraryTableLoop
       inc    hl
       ld     c,(hl)
       inc    hl
       ld     (CurLibTabEntry),hl
       ld     b,(hl)
       ex     de,hl
       bit    SkipNextCmd,(iy+SlideFlags)
       res    SkipNextCmd,(iy+SlideFlags)
       jp     nz,SlideReturn
       inc    hl
       ld     a,(hl)
       add    a,a           ; 1/4
       add    a,c           ; 1/4
       ld     c,a           ; 1/4
       ld     a,0           ; 2/7
       adc    a,b           ; 1/4
       ld     b,a           ; 1/4
       ld     a,(bc)        ; 1/7
       ld     e,a           ; 1/4
       inc    bc            ; 1/6
       ld     a,(bc)        ; 1/7
       ld     d,a           ; 1/4  ;12/55
       ld     bc,SlideReturn
       push   bc
       push   de
       inc    hl
       ret
SlideReturn:
       ld     hl,(CurLibTabEntry)
       inc    hl
       ld     e,(hl)
       inc    hl
       ld     d,(hl)
       ld     hl,(SlidePtr)
       ld     b,h
       ld     c,l
       inc    hl 
       ld     l,(hl)
       ld     h,0   
       add    hl,de  
       ld     l,(hl)
       ld     h,0
       add    hl,bc
       ld     (SlidePtr),hl
       jp     SlideLoop


LoadCoords:
       ld     a,(hl)
       call   ConvVal8Bit
       ld     (penCol),a
       ld     b,a
       inc    hl
       ld     a,(hl)
       call   ConvVal8Bit
       ld     (penRow),a
       inc    hl
       ret
       
ConvVal8Bit:
       cp     128
       ret    c
       push   hl
       push   de
       sub    128
       ld     l,a
       ld     h,0
       add    hl,hl
       ld     de,Variables
       add    hl,de
       ld     a,(hl)
       pop    de
       pop    hl
DummyReturn:
       ret

LdHLIndConvVal:
       B_CALL LdHLInd
ConvVal16Bit:
       bit    7,h
       ret    z
       push   de
       ld     de,8000h
       or     a
       sbc    hl,de
       add    hl,hl
       ld     de,Variables
       add    hl,de
       B_CALL LdHLInd
       pop    de
       ret
LdDEHLIndConvVal:
       ld     e,(hl)
       inc    hl
       ld     d,(hl)
       inc    hl
ConvVal16BitDE:
       push   hl
       ex     de,hl
       call   ConvVal16Bit
       ex     de,hl
       pop    hl
       ret

ErrorH:
;       push   hl
;       B_CALL ClrLCDFull
;       B_CALL HomeUp
;       pop    hl
;       call   PutSApp
;       B_CALL GetKey
DoQuit:
       ld     hl,(SaveSScreenSave)
       ld     (saveSScreen+768),hl
       B_JUMP JForceCmdNoChar

VPutSApp:				;display text in small font
	ld	a,(hl)
	inc	hl
	inc	a
	dec	a			;use inc and dec to preserve carry
	ret	z
	push	hl           
	push	de
	B_CALL	VPutMap
	pop	de
	pop	hl
	jr	VPutSApp

PutSApp:				;display a string of large text
	ld	a,(hl)
	inc	hl
	or	a
	ret	z
	B_CALL	PutC
	jr	PutSApp  

LoadToVar:
                                   ;Load data or variable HL into variable DE
       push   hl
       ex     de,hl
       ld     de,8000h
       or     a
       sbc    hl,de                ;HL = variable #
       add    hl,hl
       ld     de,Variables
       add    hl,de
       ex     de,hl                ;DE = location to load to
       pop    hl
       call   ConvVal16Bit
       ex     de,hl
       ld     (hl),e
       inc    hl
       ld     (hl),d
       ret

SkipNextCmdRet:
       set    SkipNextCmd,(iy+SlideFlags)
       ret
SkipThisNextRet:
       pop    de
       jp     SlideLoop

SaveTextStuff:

       push   hl
       push   af
       ld     (HLSave),hl
       ld     (ASave),a
       ld     hl,(penCol)
       ld     (PenSave),hl
       B_CALL PushRealO1
       pop    af
       pop    hl
       ret
RestoreTextStuff:
       ld     hl,(PenSave)
       ld     (penCol),hl
       B_CALL PopRealO1
       ld     a,(ASave)
       ld     hl,(HLSave)
       ret

 PUBLIC ConvVal8Bit,ConvVal16Bit,ConvVal16BitDE,LoadToVar,VPutSApp,PutSApp,SlidePtr,ErrorH
 PUBLIC LdHLIndConvVal,LdDEHLIndConvVal,SkipThisNextRet,SkipNextCmdRet,SaveTextStuff,RestoreTextStuff
 PUBLIC DoQuit,SlideReturn,LoadCoords

