;SLIDE Graphics Library 
 INCLUDE "libraries.inc"
 CreateLibrary GFX,ClearScreen,InvertScreen,Point,IfPointOn,Line,Sprite,Rect
 

 IFDEF __Sprite
_Sprite_:
       ld     a,(hl)
       call   ConvVal8Bit
       ld     e,a
       inc    hl
       ld     a,(hl)
       call   ConvVal8Bit
       ld     d,a
       inc    hl
       push   de
       call   LdHLIndConvVal
       push   hl
       B_CALL LdHLInd

       dec    h
       sra    h
       sra    h
       sra    h
       inc    h

       B_CALL HTimesL
       inc    hl
       inc    hl
       ld     b,h
       ld     c,l
       pop    hl
       ld     de,saveSScreen
       push   de
       ldir
       pop    hl
       pop    de
       B_CALL DisplayImage
       ret
 ENDIF



 IFDEF __IfPointOn
 IFNDEF __GetPixel
 DEFINE __GetPixel
 ENDIF
_IfPointOn_:
       ld     a,(hl)
       call   ConvVal8Bit
       ld     d,a
       inc    hl
       ld     a,(hl)
       call   ConvVal8Bit
       ld     e,a
       ld     d,a
       call   GetPixel
       and    (hl)
       ret    nz
       jp     SkipNextCmdRet
 ENDIF



 IFDEF __Rect
 IFNDEF __Line
 DEFINE __Line
 ENDIF
 IFNDEF __GetLineCoords
 DEFINE __GetLineCoords
 ENDIF
_Rect_:
       call   GetLineCoords
       bit    2,a
       res    2,a
       ld     (LineColor),a
       jr     nz,RectFilled
;D = left
;E = top
;B = right
;C = bottom
       push   de
       push   bc
       ld     h,b
       ld     l,e
       call   DoLine        ;top,left to top right
       pop    hl
       pop    de
       push   hl
       push   de
       ld     h,d           ;top,left to bottom,left
       inc    e
       dec    l
       call   DoLine
       pop    de
       pop    hl
       push   de
       push   hl
       ld     d,h           ;top,right to bottom,right
       inc    e
       dec    l
       call   DoLine
       pop    hl
       pop    de
       ld     e,l           ;bottom,left to bottom,right
       jp     DoLine
RectFilled:
       ld     h,b
       ld     l,e
       push   de
       push   bc
       call   DoLine
       pop    bc
       pop    de
       inc    e
       ld     a,c
       cp     e
       jr     nc,RectFilled
       ret
 ENDIF

 IFDEF __Line
 IFNDEF __Point
 DEFINE __Point
 ENDIF
 IFNDEF __GetLineCoords
 DEFINE __GetLineCoords
 ENDIF
 RAMVar LineColor,byte
 RAMVar xdir,byte
 RAMVar ydir,byte
_Line_:
       call   GetLineCoords
DoLine:       
	ld	a,1
	ld	(xdir),a
	ld	(ydir),a
	ld	a,d
	sub	h
	ld	b,a
	jp	nc,flokx
	neg
	ld	b,a
	ld	a,255
	ld	(xdir),a
flokx:
	ld	a,e
	sub	l
	ld	c,a
	jp	nc,floky
	neg
	ld	c,a
	ld	a,255
	ld	(ydir),a	
floky:
	ld	e,0	;error
	ld	a,b
	cp	c
	jp	c,fly
	ld	d,b	;resx
	inc	b
fllx:
	call	pixelonfl
	ld	a,(xdir)
	add	a,h
	ld	h,a
	ld	a,e
	add	a,c
	ld	e,a
	cp	d
	jp	c,flxok
	sub	d
	ld	e,a
	ld	a,(ydir)
	add	a,l
	ld	l,a
flxok:
	djnz	fllx
	ret
fly:
	ld	a,b
	ld	b,c
	ld	c,a
	ld	d,b
	inc	b
flly:
	call	pixelonfl
	ld	a,(ydir)
	add	a,l
	ld	l,a
	ld	a,e
	add	a,c
	ld	e,a
	cp	d
	jp	c,flyok
	sub	d
	ld	e,a
	ld	a,(xdir)
	add	a,h
	ld	h,a
flyok:
	djnz	flly
	ret

pixelonfl:
       push   hl
       push   de
       push   bc
       ex     de,hl
       ld     a,(LineColor)
       call   PointLineCont
       pop    bc
       pop    de
       pop    hl
       ret
 ENDIF



 IFDEF __Point
 IFNDEF __GetPixel
 DEFINE __GetPixel
 ENDIF
 IFNDEF __GetLineCoords
 DEFINE __GetLineCoords
 ENDIF
_Point_:
;       ld     a,(hl)
;       call   ConvVal8Bit
;       ld     d,a
;       inc    hl
;       ld     a,(hl)
;       call   ConvVal8Bit
;       ld     e,a
;       inc    hl
;       ld     a,(hl)
;       call   ConvVal8Bit
       call   GetLineCoords
PointLineCont:
       ld     c,a
       ld     a,d
       push   de
       inc    c
       dec    c
       jr     z,PointOff
       dec    c
       jr     z,PointOn

	call	GetPixel
	xor	(hl)
PointCont:
       ld     (hl),a
       pop    de                   ;D = X, E = Y
       push   af
       ld     a,d
       srl    a
       srl    a
       srl    a
       add    a,20h
       out    (10h),a
       B_CALL LCDBusy
       ld     a,80h
       add    a,e
       out    (10h),a
       B_CALL LCDBusy
       pop    af
       out    (11h),a
       ret
PointOff:
       call   GetPixel
       cpl
       and    (hl)
       jr     PointCont
PointOn:
       call   GetPixel
       or     (hl)
       jr     PointCont
 ENDIF

 IFDEF __GetPixel
GetPixel:
                            ;A = X coord
                            ;E = y coord
       ld     d,0
       ld     h,d
       ld     l,e
       add    hl,de
       add    hl,de
       add    hl,hl
       add    hl,hl
       ld     de,plotSScreen
       add    hl,de
       ld     b,0
       ld     c,a
       and    7
       srl    c
       srl    c
       srl    c
       add    hl,bc
       ld     b,a
       inc    b
       ld     a,1
GetPixelLoop:
       rrca
       djnz   GetPixelLoop
	ret
 ENDIF

 IFDEF __ClearScreen
_ClearScreen_:
       B_CALL ClrLCDFull
       B_CALL GrBufClr
       ret
 ENDIF
 IFDEF __InvertScreen
_InvertScreen_:
       ld     hl,plotSScreen
       ld     bc,768
InvertScreenLoop:
       ld     a,(hl)
       cpl
       ld     (hl),a
       inc    hl
       dec    bc
       ld     a,b
       or     c
       jr     nz,InvertScreenLoop
       B_CALL GrBufCpy
       ret
 ENDIF       

 
 IFDEF __GetLineCoords
GetLineCoords:
       ld     a,(hl)
       call   ConvVal8Bit
       ld     d,a
       inc    hl
       ld     a,(hl)
       call   ConvVal8Bit
       ld     e,a
       inc    hl
       ld     a,(hl)
       call   ConvVal8Bit
       ld     b,a
       inc    hl
       ld     a,(hl)
       call   ConvVal8Bit
       ld     c,a
       inc    hl
       ld     a,(hl)
       call   ConvVal8Bit
       ld     (LineColor),a
       ld     h,b
       ld     l,c
       ret
 ENDIF
     

GFXNext:
 IFDEF _S_ClearScreen
       db     2
 ENDIF
 IFDEF _S_InvertScreen
       db     2
 ENDIF
 IFDEF _S_Point
       db     5
 ENDIF
 IFDEF _S_IfPointOn
       db     4
 ENDIF
 IFDEF _S_Line
       db     7
 ENDIF
 IFDEF _S_Sprite
       db     6
 ENDIF
 IFDEF _S_Rect
       db     7
 ENDIF
 PUBLIC _Sprite_
