;SLIDE AppVar Library 


 INCLUDE "libraries.inc"

 CreateLibrary AppVar,IfAppVarExist,IfAppVarNExist,MakeAppVar,WriteAppVar,ReadAppVar


;**********AppVar Settings************
_AVSize EQU 4
_AVDefault:
 dw    0,0,0,0
;*************************************



 IFDEF __IfAppVarExist
_IfAppVarExist_:
       call   LookupAppVar
       ret    nc
       jp     SkipNextCmdRet
 ENDIF

 IFDEF __IfAppVarNExist
_IfAppVarNExist_:
       call   LookupAppVar
       ret    c
       jp     SkipNextCmdRet
 ENDIF

 IFDEF __MakeAppVar
_MakeAppVar_:
       call   LookupAppVar
       ret    nc
       ld     hl,_AVSize*2
       B_CALL EnoughMem
       jr     nc,MakeAVRAMOK
       B_JUMP ErrMemory
MakeAVRAMOK:
       ex     de,hl
       push   hl
       B_CALL CreateAppVar
       inc    de
       inc    de
       pop    bc
       ld     hl,_AVDefault
       ldir
       ret
 ENDIF

 IFDEF __WriteAppVar
_WriteAppVar_:
       call   LdDEHLIndConvVal     ;Offset
       call   LdHLIndConvVal
       push   hl
       push   de
       call   LookupAppVar
       pop    hl
       add    hl,hl
       add    hl,de
       inc    hl
       inc    hl                   ;skip size bytes
       pop    de
       ld     (hl),e
       inc    hl
       ld     (hl),d
       ret
 ENDIF

 IFDEF __ReadAppVar
_ReadAppVar_:
       call   LdDEHLIndConvVal
       B_CALL LdHLInd
       push   hl
       push   de
       call   LookupAppVar
       pop    hl
       add    hl,hl
       add    hl,de
       inc    hl
       inc    hl
       B_CALL LdHLInd
       pop    de
       jp     LoadToVar
 ENDIF

LookupAppVar:
       ld     de,OP1
       ld     hl,4012h
       ld     a,AppVarObj
       ld     (de),a
       inc    de
       B_CALL Mov9B
       B_CALL ChkFindSym
       ret

AppVarNext:
 IFDEF _S_IfAppVarExist
       db     2
 ENDIF
 IFDEF _S_IfAppVarNExist
       db     2
 ENDIF
 IFDEF _S_MakeAppVar
       db     2
 ENDIF
 IFDEF _S_WriteAppVar
       db     6
 ENDIF
 IFDEF _S_ReadAppVar
       db     6
 ENDIF


