;Sample SLIDE application
 INCLUDE "slides.inc"              ;You must include this file, and include it before others
 INCLUDE "mainlib.inc"             ;Main provides basic language commands; Jump, If, Load, etc.
 INCLUDE "gfxlib.inc"              ;GFX provides graphics commands; Point, ClearScreen, Line, etc.
 INCLUDE "textlib.inc"             ;Text provides text commands; SmallText,LargeChar,BlackText, etc.
 INCLUDE "misclib.inc"             ;Misc provides misc commands; Delay, WaitKey, LoadKey, etc.
 INCLUDE "mathlib.inc"             ;Math provides 16-bit math commands; plus, minus, mult, dec, etc.
 INCLUDE "silverlib.inc"           ;Silver provides SE commands; IfSliver, FastSpeed, SlowSpeed, etc.
 INCLUDE "floatlib.inc"            ;Float provies floating point commands; FAdd, FLoad, FLargeNum, etc.
 INCLUDE "appvarlib.inc"   

 ;Future planned libraries: Effects


;Command Reference:
;MAIN LIBRARY - 
;Load To,From                     - Loads data from From to To
; EX - Load VarA,100
;Copy From,To                     - Loads data from From to To
; EX - Copy 100,VarA
;IfEqu Value1,Value2              - Executes next command if Value1 = Value2
; EX - IfEqu VarA,100
;IfNEqu Value1,Value2             - Executes next command if Value1 <> Value2
; EX - IfNEqu VarA,VarB
;IfGreater Value1,Value2          - Executes next command if Value1 > Value2
; EX - IfGreater 65,VarA
;IfLess Value1,Value2             - Executes next command if Value1 < Value2
; EX - IfLess 100,VarA
;Exec Location                    - Executes an assembly language subroutine
; EX - Exec MyAsmRoutine
;Jump Location                    - Jumps to a slide or a label
; EX - Jump MyLabelName      
;LoopToZero Variable,Location     - Decrements Variable and if it's not zero, jumps to Location
; EX - LoopToZero VarA,MyLabelName      
;LoopToNum Var,Value1,Loc,[Value2]- Adds Value2 (Default 1) to Var; if not greater/equal to Value1 jumps to Loc
; EX - LoopToNum VarA,100,MyLabel
;Slide Location                   - Calls a slide as a subroutine
; EX - Slide MySlideName
;Return                           - Returns from a Slide call
; EX - Return
;Quit                             - Returns to the operating system
; EX - Quit

;GFX LIBRARY - 
;ClearScreen                      - Clears the screen
; EX - ClearScreen
;InvertScreen                     - Inverts the screen
; EX - InvertScreen
;Point X,Y,Action                 - Turns point (X,Y) on, off, or xor.  Use PointOn, PointOff, or PointXor for action
; EX - Point 5,5,PointOn
;Line X1,Y1,X2,Y2,Action          - Draws a line from (X1,Y1) to (X2,Y2).  User PointOn, PointOff, or PointXor.
; EX - Line 0,0,20,20,PointOn
;Sprite X,Y,SpriteData            - Displays a SpriteData at (X,Y)
; EX - Sprite 5,5,MySprite

;TEXT LIBRARY - 
;SmallText X,Y,Text,[Color]       - Displays Text at (X,Y) in small font (optional Color=TextWhite)
; EX - SmallText 5,5,"Text"
;LargeText X,Y,Text,[Color]       - Displays Text at (X,Y) in large font  (optional Color=TextWhite)
; EX - LargeText 5,5,"Text"
;SmallNum X,Y,Number              - Displays Number at (X,Y) in small font
; EX - SmallNum 5,5,200
;LargeNum X,Y,Number              - Displays Number at (X,Y) in large font
; EX - LargeNum 5,5,VarA
;SmallChar X,Y,Character          - Displays Character at (X,Y) in small font
; EX - SmallChar 5,5,VarA
;LargeChar X,Y,Chatecter          - Displays Character at (X,Y) in large font
; EX - LargeChar 5,5,'Z'
;BlackText                        - Sets black on white text mode
; EX - BlackText
;WhiteText                        - Sets white on black text mode
; EX - WhiteText

;MISC LIBRARY - 
;Delay Value                       - Pauses for an amount of time determined by Value
; EX - Delay 20
;LoadKey Variable                  - Loads the currently pressed key to a Variable
; EX - LoadKey VarA
;IfKey Value                       - Executes the next command if current key is equal to Value
; EX - IfKey skEnter
;IfNKey Value                      - Executes the next command if current key is not equal to Value
; EX - IfNKey skEnter
;WaitKey                           - Waits for any key to be pressed
; EX - WaitKey
;LoadWaitKey Variable              - Waits for any key then loads it to a Variable
; EX - LoadWaitKey VarA
;PauseForKey Value                 - Waits until key Value is pressed
; EX - PauseForKey skEnter

;MATH LIBRARY
;Plus Value1,Value2,[Variable]     - Adds Value1 to Value2 and stores the result to Variable
; EX - Plus VarA,25,VarA
;Minus Value1,Value2,[Variable]    - Subtracts Value2 from Value1 and stores result to Variable
; EX - Minus VarA,VarB,VarC
;Inc Variable                      - Increments a variable
; EX - Inc VarA
;Dec Variable                      - Decrements a variable
; EX - Dec VarA
;Mult Value1,Value2,[Variable]     - Multiplies Value1 and Value2 and stores the result to Variable
; EX - Mult 25,VarA,VarB
;Rand Max,Variable                 - Stores a random number between 0 and Max-1 to Variable
; EX - Rand 1000,VarA
;......For Plus, Minus, and Mult, if the third operand is omitted, the result will be stored to Value1 (which
; must be a variable in this case).

;SILVER LIBRARY
;IfSilver                          - Executes the next command if running on a silver edition calculator
; EX - IfSilver
;IfNSilver                         - Executes the next command if not running on a silver edition calculator
; EX - IfNSilver
;FastSpeed                         - Sets execution speed to 15 MHZ if on a silver edition
; EX - FastSpeed
;SlowSpeed                         - Sets execution speed to 6 MHZ
; EX - SlowSpeed
;DelayMilli Value                  - Delays for Value milliseconds (More accurate than Delay)
; EX - DelayMilli 1000

;There are currently 26 Variables, VarA through VarZ; more will probably be added in the future.
;You can use a Variable in any place you can use a number.
;Variables are always positive and have a maximum value of 32,767 (may change to 60,000 in the future)
;If you need negative values, or larger numbers, use the floating point library
;You can rename Variables with the Rename command
 Rename VarB,Var0
 Rename VarC,Var1
 Rename VarD,Var2
 Rename VarE,Var3
 Rename VarF,Var4
 Rename VarG,Var5
 Rename VarH,Var6
 Rename VarI,Var7
 Rename VarJ,Var8
 Rename VarK,Var9
 Rename VarL,LoopCounter
 Rename VarM,VarR1
 Rename VarN,VarR2
 Rename VarV,KeyVar

;Remember that all commands must have at least one space before them.
;The DefineMainSlide command tells the interpreter where to go on startup.

 DefineMainSlide MainMenu

      
       MakeAppVar
       ReadAppVar 0,VarA
       Inc VarA
       WriteAppVar 0,VarA
       Load VarA,0
       FastSpeed
       ClearScreen
       Load   VarV,42
       SmallText 0,0,"1) Random Pixel Test"
       SmallText 0,6,"2) Random Freq Test"
       SmallText 0,12,"3) Random Repeat Test"
       SmallText 0,18,"4) Pixel Fill Test"
       SmallText 0,24,"5) Line Fill Test"
       SmallText 0,30,"6) Loop/Disp Speed Test"
       SmallText 0,36,"7) Float Prime Test"
       SmallText 0,VarV,"8) Float Random Test"
       SmallText 0,48,"9) More"
       SmallText 0,54,"0) Quit"


       LoadWaitKey KeyVar
       IfEqu KeyVar,sk1
       Slide RandomSpeedTest
       IfEqu KeyVar,sk2
       Slide RandomTest
       IfEqu KeyVar,sk3
       Slide RandomRepeatTest
       IfEqu KeyVar,sk4
       Slide FillTest
       IfEqu KeyVar,sk5
       Slide LineFillTest
       IfEqu KeyVar,sk6
       Slide NumTest
       IfEqu KeyVar,sk7
       Slide FloatPrimeTest
       IfEqu KeyVar,sk8
       Slide FloatRandomTest
       IfEqu KeyVar,sk9
       Jump   Menu2
       IfNEqu KeyVar,sk0
       Jump MainMenu
       Return


 DefineSlide Menu2
       Load VarA,0
       FastSpeed
       ClearScreen
       SmallText 0,0,"1) Sprite Fill Test"
       SmallText 0,6,"2) Random Sprite Test"
       SmallText 0,12,"3) Sprite Disp Test"
       IfSilver
       SmallText 0,18,"4) DelayMilli Test"
       SmallText 0,24,"5) AppVar Count"
       SmallText 0,48,"9) More"
       SmallText 0,54,"0) Quit"
       LoadWaitKey KeyVar
       IfEqu KeyVar,sk1
       Slide SpriteFillTest
       IfEqu KeyVar,sk2
       Slide SpriteRandomTest
       IfEqu KeyVar,sk3
       Slide SpriteTest
       IfEqu KeyVar,sk4
       Slide SETimerTest
       IfEqu KeyVar,sk5
       Slide AVCountTest
       IfEqu KeyVar,sk9
       Jump   MainMenu
       IfNEqu KeyVar,sk0
       Jump   Menu2
       Return

AVCountTest:
       ClearScreen
       ReadAppVar 0,VarA
       LargeText 0,0,"Run Count: "
       LargeNum 62,0,VarA
       WaitKey
       Return

LineFillTest:
       ClearScreen
       Load   VarA,63
LineFillLoop:
       IfKey  skEnter
       Return
       Line   0,VarA,95,VarA,PointOn
       LoopToZero VarA,LineFillLoop
       WaitKey
       Return

 DefineSlide FloatPrimeTest

                                   ;BASIC - To 1009 in 2 min 19 sec
                                   ;SLIDE - To 1009 in 1 min 3 sec
                                   ;SLIDE (SE) - To 1009 in 28 sec
       ClearScreen
       FLoad  Float1,3             ;Current Number to Check
FloatPrimeLoop1:
       FLoad  Float2,Float1
       FSqRoot Float2              ;Max check for this num
       FLoad  Float3,3             ;Current Check num
FloatPrimeLoop2:
       IfKey  skEnter
       Return
       FIfGreater Float3,Float2
       Jump   FloatPrimePrime
       FDiv   Float1,Float3,Float4
       FLoad  Float5,Float4
       FIPart Float5
       FIfEqu Float4,Float5
       Jump   FloatPrimeNotPrime
       FPlus  Float3,2
       Jump   FloatPrimeLoop2

FloatPrimePrime:
       FLargeNum 0,0,Float1
FloatPrimeNotPrime:
       FPlus  Float1,2
       Jump   FloatPrimeLoop1


 DefineSlide RandomRepeatTest
       ClearScreen
       Rand   32767,VarA
       Load   VarC,0
       Load   VarD,0
       LargeNum 0,0,0
RandomRepeatLoop:
       Rand   32767,VarB
       Inc    VarC
       IfEqu  VarC,1000
       Slide  RandomRepeatInc
       LargeNum 0,8,VarC
       IfKey  skEnter
       Return
       IfNEqu VarA,VarB
       Jump   RandomRepeatLoop
       WaitKey
       Return
RandomRepeatInc:
       Load   VarC,0
       Inc    VarD
       LargeNum 0,0,VarD
       Return


 DefineSlide SETimerTest
       IfNSilver
       Return
       ClearScreen
       Load VarA,0
SETimerTestLoop:
       LargeNum 0,0,VarA
       DelayMilli 5000
       IfKey skEnter
       Return

       Plus   VarA,5
       Jump   SETimerTestLoop

 DefineSlide NumTest
       ClearScreen
       Load VarA,0
       Load VarB,30000
NumLoop:
       LargeNum 0,0,VarA
       Inc    VarA
       IfKey  skEnter
       Return
       LoopToZero VarB,NumLoop
       WaitKey
       Return


 DefineSlide FillTest
       ClearScreen
       Load   VarA,95
       Load   VarB,63
FillLoop1:
       Point  VarA,VarB,PointOn
       LoopToZero VarA,FillLoop1
       Load   VarA,95
       IfKey  skEnter
       Return
       LoopToZero VarB,FillLoop1
       WaitKey
       Return

 DefineSlide RandomSpeedTest
       ClearScreen
RandSpeedLoop:
       Rand   96,VarR1
       Rand   64,VarR2
       Point  VarR1,VarR2,PointOn
       IfNKey skEnter
       Jump   RandSpeedLoop
       Return


DoRandLoad:
       ld     hl,VarA
       call   ConvVal16Bit
       ld     de,Var0
       add    hl,de
       push   hl
       call   ConvVal16Bit
       inc    hl
       pop    de
       jp     LoadToVar

ClearVariables:
       ld     hl,Variables
       ld     bc,26*2
       B_CALL MemClear
       ret


 DefineSlide FloatRandomTest
       ClearScreen
       Exec   ClearVariables
       Load   LoopCounter,32767
FloatRandLoop:
       FRand  10,Float1
       FToVar Float1,VarA
       Exec   DoRandLoad
       SmallNum 0,0,Var0
       SmallNum 30,0,Var1
       SmallNum 60,0,Var2
       SmallNum 0,10,Var3
       SmallNum 30,10,Var4
       SmallNum 60,10,Var5
       SmallNum 0,20,Var6
       SmallNum 30,20,Var7
       SmallNum 60,20,Var8
       SmallNum 0,30,Var9
       IfKey  skEnter
       Return
       LoopToZero LoopCounter,FloatRandLoop
       WaitKey
       Return

 DefineSlide RandomTest
       ClearScreen
       Exec   ClearVariables
       Load   LoopCounter,32767
RandLoop:
       Rand   10,VarA
       Exec   DoRandLoad
       SmallNum 0,0,Var0
       SmallNum 30,0,Var1
       SmallNum 60,0,Var2
       SmallNum 0,10,Var3
       SmallNum 30,10,Var4
       SmallNum 60,10,Var5
       SmallNum 0,20,Var6
       SmallNum 30,20,Var7
       SmallNum 60,20,Var8
       SmallNum 0,30,Var9
       IfKey  skEnter
       Return
       LoopToZero LoopCounter,RandLoop
       WaitKey
       Return

 DefineSprite MySprite,1,1
 db    128

 DefineSprite SmileSprite,8,8
 db    01100110b
 db    01100110b
 db    00000000b
 db    00011000b
 db    00011000b
 db    10000001b
 db    01000010b
 db    00111100b

 DefineSlide SpriteRandomTest
       ClearScreen
RandomSpriteLoop:
       Rand 65-8,VarB
       Rand 97-8,VarA
       Sprite VarA,VarB,SmileSprite
       IfKey  skEnter
       Return
       Jump   RandomSpriteLoop

 DefineSlide SpriteTest
       Load   VarC,0
SpriteTestLoop1:
       ClearScreen
       Load   VarA,VarC
SpriteTestLoop2:
       Load   VarB,0
SpriteTestLoop3:
       Sprite VarA,VarB,SmileSprite
       LoopToNum VarB,64,SpriteTestLoop3,8
       IfKey  skEnter
       Return
       LoopToNum VarA,96,SpriteTestLoop2,8
       Inc    VarC
       IfNEqu VarC,88
       Jump   SpriteTestLoop1
       WaitKey
       Return


 DefineSlide SpriteFillTest


       ClearScreen
       Load   VarA,0
       Load   VarB,63
SpriteFillLoop:
       Sprite VarA,VarB,MySprite
       LoopToNum VarA,96,SpriteFillLoop,1
       Load   VarA,0
       IfKey  skEnter
       Return
       LoopToZero VarB,SpriteFillLoop
       WaitKey
       Return


