;Sample SLIDE application
 INCLUDE "slides.inc"              ;You must include this file, and include it before others
 INCLUDE "mainlib.inc"             ;Main provides basic language commands; Jump, If, Load, etc.
 INCLUDE "gfxlib.inc"              ;GFX provides graphics commands; Point, ClearScreen, Line, etc.
 INCLUDE "textlib.inc"             ;Text provides text commands; SmallText,LargeChar,BlackText, etc.
 INCLUDE "misclib.inc"             ;Misc provides misc commands; Delay, WaitKey, LoadKey, etc.
 INCLUDE "mathlib.inc"             ;Math provides 16-bit math commands; plus, minus, mult, dec, etc.
 INCLUDE "silverlib.inc"           ;Silver provides SE commands; IfSliver, FastSpeed, SlowSpeed, etc.
 INCLUDE "floatlib.inc"            ;Float provies floating point commands; FAdd, FLoad, FLargeNum, etc.
 INCLUDE "appvarlib.inc"   

 DefineMainSlide MainSlide
       MakeAppVar
       ReadAppVar    0,VarA
       Inc           VarA
       WriteAppVar   0,VarA
       Slide         LogoSlide
       Slide         ScreenFlash
       FastSpeed
       SmallText     23,55,"Press Any Key"
       Slide         Border
       WaitKey
MainMenu:     
       Slide         ShowScreen
       SmallText     2,2,"SLIDE is a new programming"
       SmallText     2,8,"language for the TI-83 Plus,"
       SmallText     2,14,"TI-83 Plus Silver Edition,"
       SmallText     2,20,"and TI-73 calculators."
       SmallText     2,35,"1) Features"
       SmallText     2,41,"2) Advantages"
       SmallText     2,47,"3) SLIDEShow"
       SmallText     2,53,"4) Quit"
MenuLoop:
       LoadWaitKey   VarA
       IfEqu         VarA,sk1
       Jump          SlideFeatures
       IfEqu         VarA,sk2
       Jump          SlideAdvantages
       IfEqu         VarA,sk3
       Jump          SlideShow
       IfEqu         VarA,sk4
       Return
       Jump          MenuLoop

SlideFeatures:
       ReadAppVar    1,VarA
       Inc           VarA
       WriteAppVar   1,VarA
       ClearScreen
       Slide         Border
       SmallText     2,2,"Want to write applications"
       SmallText     2,8,"but don't know assembly"
       SmallText     2,14,"language?"
       SmallText     2,24,"Trying to learn assembly"
       SmallText     2,30,"language but wish there"
       SmallText     2,36,"was something simpler?"
       SmallText     20,50,"SLIDE is for you!"
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"SLIDE is a new language"
       SmallText     2,8,"that combines the speed"
       SmallText     2,14,"and power of assembly"
       SmallText     2,20,"language with the ease"
       SmallText     2,26,"of use of BASIC."
       SmallText     2,36,"SLIDE lets you use"
       SmallText     2,42,"the familiar environment"
       SmallText     2,48,"of ZDS."
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"By using libraries to"
       SmallText     2,8,"provide commands for"
       SmallText     2,14,"the language, SLIDE is"
       SmallText     2,20,"easily extendible to"
       SmallText     2,26,"add new commands."
       SmallText     2,36,"Libraries also save"
       SmallText     2,42,"space by only including"
       SmallText     2,48,"the commands you need"
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"No coding experience is"
       SmallText     2,8,"needed to create SLIDE"
       SmallText     2,14,"applications, but SLIDE"
       SmallText     2,20,"is interoperable with"
       SmallText     2,26,"assembly language sub-"
       SmallText     2,32,"routines for convenience"
       SmallText     2,38,"of programmers wishing to"
       SmallText     2,44,"mix SLIDE and assembly"
       SmallText     2,50,"language."
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"SLIDE was not created for"
       SmallText     2,8,"processor intensive uses"
       SmallText     2,14,"like games, but for most"
       SmallText     2,20,"uses, SLIDE will perform"
       SmallText     2,26,"comparable to ASM programs"
       SmallText     2,32,"In all cases, applications"
       SmallText     2,38,"written in SLIDE will be"
       SmallText     2,44,"significantly faster than"
       SmallText     2,50,"their BASIC equivilants"
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"SLIDE's goal is to allow"
       SmallText     2,8,"the creation of high"
       SmallText     2,14,"quality applications"
       SmallText     2,20,"by the average calculator"
       SmallText     2,26,"user, not just by advanced"
       SmallText     2,32,"programmers."
       SmallText     2,42,"Have fun SLIDEing!!!"
       Slide         BottomWait
       Jump          MainMenu
       
SlideAdvantages:
       ReadAppVar    2,VarA
       Inc           VarA
       WriteAppVar   2,VarA
       ClearScreen
       Slide         Border
       SmallText     2,2,"SLIDE is a midway point"
       SmallText     2,8,"between assembly and"
       SmallText     2,14,"BASIC programming, and"
       SmallText     2,20,"has advantages over both."
       SmallText     2,30,"Listed on the following"
       SmallText     2,36,"pages are a few of the"
       SmallText     2,42,"reasons why SLIDE is a"
       SmallText     2,48,"a great language choice."
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"EASY TO LEARN AND USE"
       SmallText     2,8,"SLIDE provides fully"
       SmallText     2,14,"functional commands"
       SmallText     2,20,"like BASIC and other"
       SmallText     2,26,"high level languages."
       SmallText     2,32,"You don't have to worry"
       SmallText     2,38,"about registers, ports,"
       SmallText     2,44,"or any other assembly"
       SmallText     2,50,"language annoyances."
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"FAST EXECUTION SPEED"
       SmallText     2,8,"Although SLIDE is a"
       SmallText     2,14,"completely interpreted"
       SmallText     2,20,"language, it is several"
       SmallText     2,26,"times faster than BASIC"
       SmallText     2,32,"and often approaches"
       SmallText     2,38,"of pure assembly"
       SmallText     2,44,"language programming"
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"POWERFUL LIBRARIES"
       SmallText     2,8,"All of SLIDE's commands"
       SmallText     2,14,"are provided through"
       SmallText     2,20,"libraries.  Libraries"
       SmallText     2,26,"save space by only"
       SmallText     2,32,"including necessary"
       SmallText     2,38,"commands, and allows"
       SmallText     2,44,"the language to be"
       SmallText     2,50,"to be easily extended."
       Slide         BottomWait
       ClearScreen
       Slide         Border
       SmallText     2,2,"ERROR CHECKING"
       SmallText     2,8,"Because SLIDE is an"
       SmallText     2,14,"interpreted language,"
       SmallText     2,20,"both compile-time and"
       SmallText     2,26,"run-time error"
       SmallText     2,32,"checking are possible"
       SmallText     2,38,"This helps debugging"
       SmallText     2,44,"and prevents crashes"
       Slide         BottomWait
       Jump          MainMenu

SlideShow:
       ReadAppVar    3,VarA
       Inc           VarA
       WriteAppVar   3,VarA
       Slide         ShowScreen
       SmallText     2,2,"The text library provides"
       SmallText     2,8,"commands to displays all"
       SmallText     2,14,"sorts of text data."
       SmallText     5,33,"Reverse Text!",TextWhite
       LargeText     20,40,"Large Text!"
       LargeText     8,48,"Numbers: ",TextWhite
       LargeNum      56,48,12345
       SmallText     40,56,"Characters: "
       SmallChar     83,56,23h
       SmallChar     89,56,24h
       Slide         BottomWaitN
       Slide         ShowScreen
       SmallText     2,2,"The graphics library adds"
       SmallText     2,8,"a variety of fast drawing"
       SmallText     2,14,"and display related"
       SmallText     2,20,"commands."
       InvertScreen
       Load          VarA,1
       Load          VarB,94
LineLoop:
       Line          VarA,32,VarA,62,PointXor
       Line          VarB,32,VarB,62,PointXor
       Inc           VarA
       IfAnyKey
       Jump          MiscStart
       LoopToZero    VarB,LineLoop
       Load          VarA,6000
PointLoop:
       FRand         93,Float1
       FRand         30,Float2
       FToVar        Float1,VarB
       FToVar        Float2,VarC
       Plus          VarC,31
       Point         VarB,VarC,PointOff
       IfAnyKey
       Jump          MiscStart
       LoopToZero    VarA,PointLoop
MiscStart:
       Slide         ShowScreen
       SmallText     2,2,"The misc library gives"
       SmallText     2,8,"the programmer access"
       SmallText     2,14,"to the keyboard and other"
       SmallText     2,20,"miscelaneous commands."
       Sprite        65,33,KeySprite
MiscLoop:
       Delay         5
       LoadKey       VarA
       IfNEqu        VarA,0
       Sprite        65,33,KeySprite
       IfEqu         VarA,0
       SmallText     5,40,"No Key Pressed"
       IfEqu         VarA,0
       Jump          MiscCont
       SmallText     5,40,"Key Pressed                 "
       SmallText     5,46,"Key Code:                   "
       SmallNum      40,46,VarA
MiscCont:
       IfEqu         VarA,skLeft
       Sprite        65,41,LeftSprite
       IfEqu         VarA,skRight
       Sprite        81,41,RightSprite
       IfEqu         VarA,skUp
       Sprite        73,33,UpSprite
       IfEqu         VarA,skDown
       Sprite        73,49,DownSprite
       IfEqu         VarA,skEnter
       Jump          MathStart
       Jump          MiscLoop
MathStart:
       Slide         ShowScreen
       SmallText     2,2,"The math library priovides"
       SmallText     2,8,"simple integer math"
       SmallText     2,14,"commands."
       Line          5,48,25,48,PointOn
       Line          27,48,47,48,PointOn
       Line          49,48,69,48,PointOn
       Line          71,48,91,48,PointOn
       Load          VarA,1
       SmallChar     7,41,'+'
       SmallChar     29,41,'-'
       SmallChar     50,41,'*'
       SmallChar     72,41,'/'

MathLoop2:
       SmallNum      15,41,VarA
       SmallNum      37,41,VarA
       SmallNum      58,41,VarA
       SmallNum      80,41,VarA
       SmallText     9,50,"                      "
       SmallText     31,50,"                     "
       SmallText     52,50,"                     "
       SmallText     74,50,"                     "
       SmallText     15,34,"             "
       SmallText     37,34,"             "
       SmallText     58,34,"             "
       SmallText     80,34,"             "
       Load          VarB,VarA
MathLoop1:

       SmallNum      15,34,VarB
       SmallNum      37,34,VarB
       SmallNum      58,34,VarB
       SmallNum      80,34,VarB
       Plus          VarA,VarB,VarC
       SmallNum      9,50,VarC
       Minus         VarB,VarA,VarC
       SmallNum      31,50,VarC
       Mult          VarA,VarB,VarC
       SmallNum      52,50,VarC
       Div           VarB,VarA,VarC
       SmallNum      74,50,VarC
       IfAnyKey
       Jump          FloatStart
       LoopToNum     VarB,90,MathLoop1
       LoopToNum     VarA,70,MathLoop2

FloatStart:
       Slide         ShowScreen
       SmallText     2,2,"The float library adds"
       SmallText     2,8,"floating point data types"
       SmallText     2,14,"and related commands to"
       SmallText     2,20,"the SLIDE language"
       SmallText     2,34,"Current Number: "
       SmallText     2,40,"Random Numbers: "
       SmallText     2,46,"Prime Numbers: "
       SmallText     2,52,"Square Numbers: "
       FLoad         Float8,1
       FLoad         Float7,3
       Load          VarA,999
FloatLoop:
       IfAnyKey
       Jump          SilverStart
       FRand         100,Float1
       FSmallNum     60,40,Float1
       Slide         GetNextPrime
       IfEqu         VarZ,1
       Jump          SilverStart
       FSmallNum     60,46,Float7
       FSmallNum     60,34,Float8
       FPlus         Float7,2
       FLoad         Float1,Float8
       FLoad         Float2,Float8
       FMult         Float1,Float2
       FInc          Float8
       FSmallNum     60,52,Float1
       LoopToZero    VarA,FloatLoop
SilverStart:
       Slide         ShowScreen
       SmallText     2,2,"The silver library lets"
       SmallText     2,8,"you detect Silver Edition"
       SmallText     2,14,"calculators and use"
       SmallText     2,20,"related commands."
       IfSilver
       SmallText     2,35,"Running on Silver Edition"
       IfSilver
       SmallText     2,41,"Running at 15 MHZ"
       IfNSilver
       SmallText     2,35,"Not running on SE"
       IfNSilver     
       SmallText     2,41,"Running at 6 MHZ"
       IfNSilver
       Slide         BottomWaitN
       IfNSilver
       Jump          AppVarStart
       Load          VarA,0
       SmallText     2,47,"Seconds (crystal): "
SilverLoop:
       SmallNum      85,47,VarA
       DelayMilli    970
       IfAnyKey
       Jump          AppVarStart
       LoopToNum     VarA,100,SilverLoop
AppVarStart:
       Slide         ShowScreen
       SmallText     2,2,"The appvar library is"
       SmallText     2,8,"used for accessing data"
       SmallText     2,14,"in application variables."
       SmallText     2,33,"Application Run: "
       ReadAppVar    0,VarA
       SmallNum      85,33,VarA
       SmallText     2,39,"Features Viewed: "
       ReadAppVar    1,VarA
       SmallNum      85,39,VarA
       SmallText     2,45,"Advantages Viewed: "
       ReadAppVar    2,VarA
       SmallNum      85,45,VarA
       SmallText     2,51,"SLIDEShow Viewed: "
       ReadAppVar    3,VarA
       SmallNum      85,51,VarA
       Slide         BottomWaitN
       

       Jump          MainMenu



 DefineSlide GetNextPrime
       Load   VarZ,0
       FLoad  Float1,Float7             ;Current Number to Check
FloatPrimeLoop1:
       FLoad  Float2,Float1
       FSqRoot Float2              ;Max check for this num
       FLoad  Float3,3             ;Current Check num
FloatPrimeLoop2:
       IfKey  skEnter
       Return
       FIfGreater Float3,Float2
       Jump   FloatPrimePrime
       FDiv   Float1,Float3,Float4
       FLoad  Float5,Float4
       FIPart Float5
       FIfEqu Float4,Float5
       Jump   FloatPrimeNotPrime
       FPlus  Float3,2
       IfAnyKey
       Jump   FloatPrimeQuit
       Jump   FloatPrimeLoop2

FloatPrimePrime:
       FLoad  Float7,Float1
       Return
FloatPrimeQuit:
       Inc    VarZ
       Return

FloatPrimeNotPrime:
       FPlus  Float1,2
       Jump   FloatPrimeLoop1



 DefineSlide BottomWait
       SmallText     55,56,"(Press Key)"
 DefineSlide BottomWaitN
       Load          VarA,1000
BottomWaitLoop:
       Delay         1
       IfAnyKey
       Return
       LoopToZero    VarA,BottomWaitLoop
       Return

 DefineSlide ShowScreen
       ClearScreen
       Slide         Border
       Line          0,31,95,31,PointOn
       Return

 DefineSlide Border
       Line          0,0,95,0,PointOn
       Line          0,0,0,63,PointOn
       Line          95,0,95,63,PointOn
       Line          95,63,0,63,PointOn
       Point         1,1,PointOn
       Point         94,1,PointOn
       Point         94,62,PointOn
       Point         1,62,PointOn
       Return


 DefineSlide LogoSlide
       Load          VarA,0
LogoSlideLoop:
       Sprite        5,VarA,SlideSprite
       IfAnyKey
       Jump          LogoSlideCont
       Delay         5
       Sprite        5,VarA,SlideClearSprite
       LoopToNum     VarA,24,LogoSlideLoop
LogoSlideCont:
       ClearScreen
       Sprite        5,24,SlideSprite
       Return



 DefineSlide ScreenFlash
       Load          VarA,8
ScreenFlashLoop:
       InvertScreen
       Delay         5
       LoopToZero    VarA,ScreenFlashLoop
       Return

;SlideSprite:
;       db     7,25
;       db     01110100b,01111101b,11000111b,1000000b
;       db     10000100b,00010001b,00100100b,0000000b
;       db     11100100b,00010001b,00010100b,0000000b
;       db     00110100b,00010001b,00010111b,0000000b
;       db     00010100b,00010001b,00010100b,0000000b
;       db     00010100b,00010001b,00100100b,0000000b
;       db     11100111b,01111101b,11000111b,1000000b


;SlideClearSprite:
;       db     7,25
;       db     0,0,0,0
;       db     0,0,0,0
;       db     0,0,0,0
;       db     0,0,0,0
;       db     0,0,0,0
;       db     0,0,0,0
;       db     0,0,0,0

SlideSprite:
       db     17,86
 db 000h,00Fh,080h,007h,081h,0FEh,00Fh,0FFh,000h,01Fh,0FCh
 db 000h,030h,0C0h,019h,083h,0FCh,073h,083h,0C0h,0E6h,00Ch
 db 000h,040h,0C0h,060h,080h,060h,0C3h,001h,0C1h,00Eh,008h
 db 000h,0C0h,080h,0C0h,000h,0C1h,007h,000h,0C2h,00Ch,000h
 db 001h,080h,001h,0C0h,001h,0C3h,006h,000h,0C6h,01Ch,000h
 db 001h,0C0h,001h,080h,001h,086h,00Eh,000h,0CCh,018h,000h
 db 001h,0C0h,003h,080h,003h,088h,01Ch,000h,0C8h,038h,000h
 db 001h,0E0h,003h,000h,003h,000h,018h,001h,080h,070h,000h
 db 000h,0F0h,006h,000h,007h,000h,038h,001h,080h,07Fh,000h
 db 000h,070h,00Eh,000h,006h,000h,030h,003h,000h,0E0h,000h
 db 000h,038h,00Ch,000h,00Eh,000h,070h,006h,000h,0C0h,000h
 db 000h,038h,01Ch,000h,00Ch,000h,060h,004h,001h,0C0h,000h
 db 000h,030h,018h,000h,018h,000h,0C0h,008h,001h,080h,000h
 db 000h,030h,030h,000h,030h,001h,080h,010h,003h,000h,000h
 db 040h,060h,040h,018h,060h,003h,000h,060h,00Ch,001h,000h
 db 0F0h,083h,0FFh,0F3h,0FCh,01Eh,001h,080h,03Fh,0FEh,000h
 db 0FFh,007h,0FFh,0C7h,0F0h,03Fh,0FEh,000h,07Fh,0F8h,000h

SlideClearSprite:
       db     17,86
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0
       db     0,0,0,0,0,0,0,0,0,0,0


LeftSprite:
       db     8,8
       db     00000111b
       db     00011111b
       db     01111111b
       db     11111111b
       db     11111111b
       db     01111111b
       db     00011111b
       db     00000111b

UpSprite:
       db     8,8
       db     00011000b
       db     00111100b
       db     00111100b
       db     01111110b
       db     01111110b
       db     11111111b
       db     11111111b
       db     11111111b

DownSprite:
       db     8,8
       db     11111111b
       db     11111111b
       db     11111111b
       db     01111110b
       db     01111110b
       db     00111100b
       db     00111100b
       db     00011000b

RightSprite:
       db     8,8
       db     11100000b
       db     11111000b
       db     11111110b
       db     11111111b
       db     11111111b
       db     11111110b
       db     11111000b
       db     11100000b


KeySprite:
       db     24,24
       db     0,00011000b,0
       db     0,00100100b,0
       db     0,00100100b,0
       db     0,01000010b,0
       db     0,01000010b,0
       db     0,10000001b,0
       db     0,10000001b,0
       db     0,11111111b,0
       db     00000111b,0,11100000b
       db     00011001b,0,10011000b
       db     01100001b,0,10000110b
       db     10000001b,0,10000001b
       db     10000001b,0,10000001b
       db     01100001b,0,10000110b
       db     00011001b,0,10011000b
       db     00000111b,0,11100000b
       db     0,11111111b,0
       db     0,10000001b,0
       db     0,10000001b,0
       db     0,01000010b,0
       db     0,01000010b,0
       db     0,00100100b,0
       db     0,00100100b,0
       db     0,00011000b,0



